# 1. Loop over all directions
# 2. For each direction, collect A and P by projection,
#    and in each plane (normal to the direction), count B and C.
# 3. For each projection, for each A and P pair, count B and C in the two planes.
import math

n = int(input())
grid = []
for _ in range(n):
    input()
    grid.append([input() for _ in range(n)])

dirs = set()
ps = []
for i in range(n):
    for j in range(n):
        for k in range(n):
            ps.append((i, j, k))
for p in ps:
    for q in ps:
        if p == q:
            continue
        di = q[0] - p[0]
        dj = q[1] - p[1]
        dk = q[2] - p[2]
        g = math.gcd(di, dj, dk)
        di //= g
        dj //= g
        dk //= g
        if di < 0 or (di == 0 and dj < 0) or (di == 0 and dj == 0 and dk < 0):
            di *= -1
            dj *= -1
            dk *= -1
        dirs.add((di, dj, dk))


ans = 0

for d in dirs:
    ll = d[0] ** 2 + d[1] ** 2 + d[2] ** 2

    # For each projection, the positions of A and P.
    proj = {}
    # Count for each plane #B and #C
    planes = {}
    for p in ps:
        char = grid[p[0]][p[1]][p[2]]
        dot = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]
        if char in "BC":
            # Plane
            if dot not in planes:
                planes[dot] = [0, 0]
            if char == "B":
                planes[dot][0] += 1
            if char == "C":
                planes[dot][1] += 1

        else:
            # Projection
            key = (
                (ll * p[0] - d[0] * dot),
                (ll * p[1] - d[1] * dot),
                (ll * p[2] - d[2] * dot),
            )

            if key not in proj:
                proj[key] = ([], [])
            if char == "A":
                proj[key][0].append(p)
            if char == "P":
                proj[key][1].append(p)

    # For each projection
    for key in proj:
        a_list, p_list = proj[key]
        for a in a_list:
            for p in p_list:
                dot_a = d[0] * a[0] + d[1] * a[1] + d[2] * a[2]
                dot_p = d[0] * p[0] + d[1] * p[1] + d[2] * p[2]

                if dot_a not in planes or dot_p not in planes:
                    continue

                ans += planes[dot_a][0] * planes[dot_p][1]

print(ans)
