#include <iostream>
#include <string>
#include <vector>

struct point{
    int x, y, z;
    point(int x_ = 0, int y_ = 0, int z_ = 0) : x(x_), y(y_), z(z_) {}
    void set_xyz(int x_, int y_, int z_) {x=x_; y=y_; z=z_;}
};

int main(){
    int n;
    std::string hyphen;
    std::cin >> n;
    std::vector<std::vector<std::string>> g(n, std::vector<std::string>(n));
    for (int x = 0; x < n; ++x) {
        std::cin >> hyphen;
        for (int y = 0; y < n; ++y) std::cin >> g[x][y];
    }
    
    std::vector<point> B(n*n*n), A(n*n*n), P(n*n*n), C(n*n*n);
    int Bn = 0, An = 0, Pn = 0, Cn = 0;
    for (int x = 0; x < n; ++x) for (int y = 0; y < n; ++y) for (int z = 0; z < n; ++z){
        switch(g[x][y][z]){
            case 'B':
            B[Bn++].set_xyz(x,y,z);
            break;
            case 'A':
            A[An++].set_xyz(x,y,z);
            break;
            case 'P':
            P[Pn++].set_xyz(x,y,z);
            break;
            case 'C':
            C[Cn++].set_xyz(x,y,z);
            break;
        }
    }
    B.resize(Bn);
    A.resize(An);
    P.resize(Pn);
    C.resize(Cn);
    
    long long ans = 0;
    for (const point &a : A) for (const point &p : P){
        int bs = 0, cs = 0;
        point d(p.x-a.x, p.y-a.y, p.z-a.z);
        int ad = a.x*d.x + a.y*d.y + a.z*d.z, pd = p.x*d.x + p.y*d.y + p.z*d.z;
        for (const point &b : B) bs += b.x*d.x + b.y*d.y + b.z*d.z == ad;
        for (const point &c : C) cs += c.x*d.x + c.y*d.y + c.z*d.z == pd;
        ans += bs * cs;
    }
    std::cout << ans << std::endl;
    
    return 0;
}
