#include <iostream>
#include <iomanip>
#include <vector>
#include <queue>
#include <algorithm>
#include <utility>
#include <cmath>

using namespace std;

typedef int coord;

class point {
public:
	coord x, y, z;

	point() { x = y = z = 0; }
	point(coord x1, coord y1, coord z1) { x = x1; y = y1; z = z1; }

	point operator +=(point a) { x += a.x; y += a.y; z += a.z; return *this; }
	point operator -=(point a) { x -= a.x; y -= a.y; z -= a.z; return *this; }
};

point operator +(point a, point b) { return a += b; }
point operator -(point a, point b) { return a -= b; }
coord operator *(point a, point b) { return a.x*b.x + a.y*b.y + a.z*b.z; }

int main()
{
	int n;
	cin >> n;

	vector<vector<string>> grid(n, vector<string>(n));

	for(int i=0; i<n; i++) {
		char sep;
		cin >> sep;
		for(int j=0; j<n; j++) cin >> grid[i][j];
	}

	string letters = "BAPC";
	vector<point> letterpos[4];

	for(int i=0; i<letters.length(); i++) {
		for(int x=0; x<n; x++) {
			for(int y=0; y<n; y++) {
				for(int z=0; z<n; z++) {
					if ( grid[x][y][z]==letters[i] ) {
						letterpos[i].push_back(point(x,y,z));
					}
				}
			}
		}
	}

	long long res = 0;
	for(int j=0; j<letterpos[1].size(); j++) {
		for(int k=0; k<letterpos[2].size(); k++) {
			point dmid = letterpos[2][k] - letterpos[1][j];
			long long a = 0, b = 0;
			for(int i=0; i<letterpos[0].size(); i++) {
				point d = letterpos[1][j] - letterpos[0][i];
				if ( d*dmid==0 ) a++;
			}
			for(int i=0; i<letterpos[3].size(); i++) {
				point d = letterpos[3][i] - letterpos[2][k];
				if ( d*dmid==0 ) b++;
			}
			res += a*b;
		}
	}

	cout << res << endl;

	return 0;
}
