// @EXPECTED_RESULTS@: WRONG_ANSWER, TIME_LIMIT_EXCEEDED
#pragma GCC optimize("Ofast")
#include <vector>
#include <iostream>
#include <algorithm>
#include <array>
#include <math.h>
#include <numeric>
#include <random>
using namespace std;
random_device rd;
mt19937 rng(rd());
const int MXD = ceil(25.4*2 + 160 + 0.00001);
const int MX = 1e7;
double sq(double x) {
    return x*x;
}
struct DSU{
    vector<int> sz,parent;
    int components;
    DSU(int n) {
        sz.assign(n,1);
        components = n;
        parent.resize(n);
        iota(begin(parent),end(parent),0);
    }
    void link(int a, int b) {
        components--;
        if(sz[a]<sz[b]) {
            swap(a,b);
        }
        sz[a]+=sz[b];
        parent[b] = a;
    }
    bool unite(int a, int b) {
        int pa = find(a),pb = find(b);
        if(pa!=pb) link(pa,pb);
        return pa!=pb;
    }
    int find(int a) {
        if(a==parent[a]) return a;
        return parent[a] = find(parent[a]);
    }
};
int main() {
    
    int n; cin >> n;
    vector<array<int,3>> cs(n);
    for(auto& [x,y,r] : cs) {
        cin >> x >> y >> r;
    }
    sort(begin(cs),end(cs));
    
    auto near = [&](int i, int j) {
        auto [x,y,r] = cs[i];
        auto [x2,y2,r2] = cs[j];
        return (sq(x-x2) + sq(y-y2) ) < sq(25.4*2 + (r+r2)/2.);
    };
    vector<array<int,2>> myblock(n);
    for(int i=0;i<n;++i) {
        myblock[i] = {cs[i][0]/MXD,cs[i][1]/MXD};
    } 

    DSU dsu(n);
    vector<int> deg(n);
    auto addE = [&](int u, int v) {
        deg[u]++;
        deg[v]++;
        dsu.unite(u,v);
    };
    for(auto [dx,dy] : {array<int,2>{0,0},{0,1},{1,-1},{1,0},{1,1}}) {
        int it = 0, jt = 0;
        for(int i=0;i<n;++i) {
            array<int,2> want = myblock[i];
            want[0]+=dx,want[1]+=dy;
            while(it!=n and myblock[it]<want) {
                ++it;
            }
            if(dx==0 and dy==0) {
                while(it<=i) {
                    ++it;
                }
            }
            while(jt!=n and myblock[jt]<=want) {
                ++jt;
            }
            for(auto kt = it;kt!=jt;++kt) {
                if(near(kt,i)) {
                    addE(kt,i);
                }
            }
        }
    }
    if(dsu.components==1 and (n<7 or *min_element(begin(deg),end(deg))>=2)) {
        cout << "yes\n";
    } else cout << "no\n";
    
    
}

