#include<bits/stdc++.h>
#pragma GCC target("avx2")
#define rep(i, a, b) for (ll i = (a); i < (b); i++)
#define all(x) (x).begin(), (x).end()
#define sz(x) (ll)size(x)
using namespace std;
using ll = long long;
using vi = vector<ll>;
using vvi = vector<vi>;
using pii = pair<ll, ll>;

mt19937 rng(chrono::steady_clock::now().time_since_epoch().count());

void solve() {
    ll n; cin >> n;
    vector<tuple<ll,ll,ll>> pieces(n);
    map<pii, vi> grid;
    const ll GRID = 250;
    const double TWO_INCHES = 2 * 25.4;
    rep(i,0,n) {
        auto &[x, y, d] = pieces[i];
        cin >> x >> y >> d;
        grid[{x / GRID, y / GRID}].push_back(i);
    }

    vvi g(n);
    auto check = [&](ll i, ll j) {
        if (i >= j) return;
        auto [ax, ay, ad] = pieces[i];
        auto [bx, by, bd] = pieces[j];
        double dist = sqrt((ax - bx) * (ax - bx) + (ay - by) * (ay - by)) - ad / 2.0 - bd / 2.0;
        if (dist <= TWO_INCHES) {
            g[i].push_back(j);
            g[j].push_back(i);
        }
    };

    for (const auto &[p, v] : grid) {
        auto [x, y] = p;
        rep(dx,-1,2) rep(dy,-1,2) {
            if (!grid.count({x+dx, y+dy})) continue;
            const auto &v2 = grid.at({x+dx, y+dy});
            for (const auto &a : v) for (const auto &b : v2) {
                check(a, b);
            }
        }
    }

    if (n >= 7) {
        rep(i,0,n) {
            if (sz(g[i]) <= 1) {
                cout << "no\n";
                return;
            }
        }
    }

    vi q = {0};
    vector<bool> visited(n);
    visited[0] = true;
    rep(i,0,sz(q)) {
        ll x = q[i];
        for (ll y : g[x]) {
            if (visited[y]) continue;
            visited[y] = true;
            q.push_back(y);
        }
    }

    if (sz(q) == n) cout << "yes\n";
    else cout << "no\n";
}

int main() {
    cin.tie(0)->sync_with_stdio(0);
    cin.exceptions(cin.failbit);

    solve();

    return 0;
}
