#!/usr/bin/env python3
import math
from collections import defaultdict

q = 50.8
w = 211
wx = 200000


class Model:
    def __init__(self, x, y, r, i):
        self.x = x
        self.y = y
        self.r = r / 2
        self.i = i

    def is_close(self, m):
        return math.sqrt((self.x - m.x) ** 2 + (self.y - m.y) ** 2) < self.r + m.r + q


n = int(input())
buckets = defaultdict(list)

for i in range(n):
    x, y, r = map(float, input().split())
    m = Model(x, y, r, i)
    xi = int(m.x / w)
    yi = int(m.y / w)
    buckets[xi * wx + yi].append(m)
    buckets[(xi + 1) * wx + yi].append(m)
    buckets[xi * wx + yi + 1].append(m)
    buckets[(xi + 1) * wx + yi + 1].append(m)

g = [set() for _ in range(n)]

for b in buckets.values():
    bc = len(b)
    for i in range(bc):
        for j in range(i + 1, bc):
            if b[i].is_close(b[j]):
                g[b[i].i].add(b[j].i)
                g[b[j].i].add(b[i].i)

if n >= 7:
    for i in range(n):
        if len(g[i]) <= 1:
            exit(print("no"))

reach = [False] * n
todo = [0]
reach[0] = True
done = 1

while todo:
    i = todo.pop()
    for j in g[i]:
        if not reach[j]:
            todo.append(j)
            reach[j] = True
            done += 1

print("yes" if done == n else "no")
