const val q: Double = 50.8
const val w: Int = 211
const val wx: Long = 200000L

fun main() {
    val n = readln().toInt()
    val buckets: MutableMap<Long, MutableList<Model>> = mutableMapOf()
    for (i in 0..<n) {
        val m = Model()
        val line = readln().split(" ")
        m.x = line[0].toLong()
        m.y = line[1].toLong()
        m.r = line[2].toDouble() / 2.0
        m.i = i
        val xi: Long = m.x / w.toLong()
        val yi: Long = m.y / w.toLong()
        val k1 = xi * wx + yi
        val k2 = (xi + 1) * wx + yi
        val k3 = xi * wx + (yi + 1)
        val k4 = (xi + 1) * wx + (yi + 1)
        buckets.getOrPut(k1) { mutableListOf() }.add(m)
        buckets.getOrPut(k2) { mutableListOf() }.add(m)
        buckets.getOrPut(k3) { mutableListOf() }.add(m)
        buckets.getOrPut(k4) { mutableListOf() }.add(m)
    }
    val g: MutableList<MutableSet<Int>> = MutableList(n) { mutableSetOf<Int>() }
    for ((_, b) in buckets) {
        val bc: Int = b.size
        for (i in 0..<bc) {
            val mi: Model = b[i]
            for (j in i + 1..<bc) {
                val mj: Model = b[j]
                if (mi.isClose(mj)) {
                    g[mi.i].add(mj.i)
                    g[mj.i].add(mi.i)
                }
            }
        }
    }
    if (n >= 7) {
        for (i in 0..<n) {
            if (g[i].size <= 1) {
                kotlin.io.println("no")
                return
            }
        }
    }
    val reach = BooleanArray(n)
    val stack = ArrayDeque<Int>()
    reach[0] = true
    stack.addLast(0)
    var done = 1
    while (stack.isNotEmpty()) {
        val i: Int = stack.removeLast()
        for (j in g[i]) if (!reach[j]) {
            reach[j] = true
            stack.addLast(j)
            ++done
        }
    }
    kotlin.io.println(if (done == n) "yes" else "no")
}

internal class Model {
    var x: Long = 0
    var y: Long = 0
    var r: Double = 0.0
    var i: Int = 0

    fun isClose(m: Model): Boolean {
        // Use hypot for numerical stability
        val dx = (x - m.x).toDouble()
        val dy = (y - m.y).toDouble()
        val dist: Double = kotlin.math.hypot(dx, dy)
        return dist < (r + m.r + q)
    }
}