#!/usr/bin/python3
from cmath import cos, pi, polar, sin, exp
from math import sqrt
from math import ceil
import sys
import random


# Read the second... arguments as ints Example call:
# example.py {seed} 1 2 3 4
n = int(sys.argv[1])
ANG = 2*pi/n
A =  int(sys.argv[2])
B = int(sys.argv[3])
assert(A<=B)
WANT = (A+B)/2
lo = 0
hi = 1
def good(R):
    return R* abs(1- exp(1j*ANG)) >= WANT+5
    
while not good(hi):
    hi*=2

for i in range(100):
    mid = (lo+hi)/2
    if good(mid):
        hi = mid
    else:
        lo = mid


circs = []
for i in range(n):
    z = exp(1j*ANG*i)*lo
    circs.append((max(A,B)*n + round(z.real),max(A,B)*n + round(z.imag), A if i%2==0 else B))


print(len(circs))
for xyd in circs:
    print(*xyd)
