#!/usr/bin/env python3



from argparse import ArgumentParser
import random

parser = ArgumentParser(
        description="N > 5 models on 28mm bases in the shape of a line with a 3-model triangle at each end."
)

parser.add_argument("N", type=int)
parser.add_argument("--incoherent", action="store_true")
parser.add_argument("--northsouth", action="store_true")

args = parser.parse_args()

assert args.N >= 5
offset = 2 if args.incoherent else 0
models: list[tuple[int, int, int]] = []
R = 14
buffer = int(25.4 * 2)
models.append((R, R, 2*R))
models.append((R,  2 * R + buffer + R, 2*R))
X = (2 * R + buffer ) * (3**.5) / 2
Y = (2 * R + buffer) / 2
for i in range(args.N - 4):
    x = X + R
    x += i * (2 * R + buffer)
    if i + 2 >= args.N//2:
        x += offset
    models.append((int(x), int(R + Y), 2*R))
x += X
models.append((int(x), R, 2*R))
models.append((int(x), 2*R + buffer + R, 2*R))

with open("testcase.in", "w") as infile:
    print(args.N, file=infile)
    for x, y, d in models:
        if args.northsouth:
            x, y = y, x
        print(x,y,d, file=infile)

with open("testcase.ans", "w") as ansfile:
    print("no" if args.incoherent else "yes", file=ansfile)
