#pragma GCC optimize("O3")
#include <chrono>
#include <algorithm>
#include <bitset>
#include <iostream>
#include <numeric>
#include <vector>
#include <random>
using namespace std;
#define rep(i,a,b) for(int i=(a); i<(b); ++i)
#define all(x) x.begin(),x.end()
#define sz(x) int(x.size())
typedef long long ll;
typedef unsigned long long ull;
typedef vector<int> vi;
typedef vector<vi> vvi;

// to quickly check if element exists, we use bitset
const int N = 100000;
typedef bitset<N> bs;
bs vis[N]; 
mt19937 rng(chrono::high_resolution_clock().now().time_since_epoch().count());
int main(){
    cin.tie(NULL),cin.sync_with_stdio(false);
    auto t0 = chrono::high_resolution_clock().now();
    int n; cin >> n;
    vvi a;
    vi inds, coords, tmp;

    rep(i,0,n){
        int k; cin >> k;
        vi v(k);
        for(auto& c : v) cin >> c;
        if (k<2) continue;
        
        a.push_back(v);
        inds.push_back(i);
        for(auto c : v) tmp.push_back(c);
    }

    n = sz(a);
    sort(all(tmp));
    rep(i,0,sz(tmp)-1) if ((!i or tmp[i-1] != tmp[i]) and tmp[i] == tmp[i+1]){
        coords.push_back(tmp[i]);
    }
    rep(i,0,n) rep(j,0,sz(a[i])){
        auto it = lower_bound(all(coords), a[i][j]);
        if (it != end(coords) and *it == a[i][j]) {
            a[i][j] = it - begin(coords);
            vis[i][a[i][j]] = 1;
        }else{
            a[i][j] = a[i].back();
            a[i].pop_back();
            --j;
        }
    }

    vi ord(n); iota(all(ord),0);
    // sort(all(ord),[&](int i, int j){ 
    //     return sz(a[i]) < sz(a[j]);
    // });
    shuffle(all(ord),rng);
    long long iter=0;
    rep(ii,0,n) if (sz(a[ord[ii]])>1) rep(jj,ii+1,n){
        int i = ord[ii], j = ord[jj];
        int frst = -1;
        
        for(auto v : a[i]) {
            iter++;
            if(iter%(1<<12)==0) {
                if((chrono::high_resolution_clock().now()-t0).count()*1e-9  >9.5) {
                    cout << "impossible\n";
                    exit(0);
                }
            }

            if (vis[j][v]){
                if (frst<0) frst = v;
                else{
                    // solution found!
                    cout << coords[frst] << ' ' << coords[v] << ' ' << inds[i]+1 << ' ' << inds[j]+1  << '\n';
                    exit(0);
                }
            }
        }

    }

    cout << "impossible\n";
}
