#pragma GCC optimize("Ofast,unroll-loops")
#include <iostream>
#include <vector>
#include <bitset>
#include <math.h>
#include <algorithm>
using namespace std;
typedef basic_string<int> vi;
#define all(x) begin(x),end(x)
constexpr size_t N = 100000;
constexpr size_t B = sqrt(N/32);
constexpr size_t V = N/B;
int main() {
    cin.tie(NULL);
    cin.sync_with_stdio(false);
    cerr << B << '\n';
    int m; cin >> m;
    vector<pair<vi,int>> A(m);
    for(int i=0;i<m;++i) A[i].second=i+1;
    vi c; c.reserve(N);
    for(auto& [v,id] : A) {
        int k; cin >> k;
        v.resize(k);
        for(auto& i : v) cin >> i, c.push_back(i);
    }
    sort(all(c));
    c.erase(unique(all(c)),c.end());
    // coordinate compression.
    for(auto& [v,id] : A) {
        for(auto& i : v) {
            i = lower_bound(all(c),i)-c.begin();
        }
        sort(all(v));
    }
    sort(all(A),[&](auto& i, auto& j) {return i.first.size()>j.first.size();});
    int k = c.size();
    
    vector<bitset<V>> bs(k); 
    // essentially bruteforce all pairs of sets, with first one being >=B, the other one: not care.
    // time complexity O(n^2/(B*32))
    for(int i=0;i<m;++i) {
        bitset<V> mine;
        for(int j : A[i].first) {
            if((mine & bs[j]).any()) { // j and some other element in set A_i share another set, so they are a good pair! 
                int who = (mine&bs[j])._Find_first();
                for(int other : A[i].first) if(bs[other][who]) {
                    cout << c[j] << ' ' << c[other] << ' ' << A[i].second << ' ' << A[who].second << '\n';
                    exit(0);
                }
            }
            mine|=bs[j];
            if(A[i].first.size()>=B) bs[j][i]=1;
        }
    }
    vector<vi> smallsets(k);
    for(int i=0;i<m;++i) if(A[i].first.size()<B) {
        for(int j : A[i].first) {
            smallsets[j].push_back(i);
        }
    }
    // only care about pairs of sets, with both < B
    vector<char> vis(k);
    // boolean flag, but vector<bool> is bad.
    // these three for loops overall are O(n * B) time complexity.
    for(int j=0;j<k;++j) { // bruteforce second element of pair
        for(int i : smallsets[j]) {
            for(int o : A[i].first) {
                if(o==j) break;
                if(vis[o]) {
                    // found it!
                    int other;
                    for(auto i2 : smallsets[j]) {
                        if(count(all(A[i2].first),o)) {
                            other=i2;
                            break;
                        }
                    }
                    cout << c[j] << ' ' << c[o] << ' ' << A[i].second << ' ' << A[other].second << '\n';
                    exit(0);
                }
                vis[o]=1;
            }
        }
        // reset visited array in same time complexity.
        for(int i : smallsets[j]) {
            for(int o : A[i].first) {
                if(o==j) break;
                vis[o]=0;
            }
        }
    }

    cout << "impossible\n";
}
/*
3     
2 1 2
3 2 3 4
5 1 5 3 6 2
*/