#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>

using namespace std;

int main() {
    int n;
    double w;
    cin >> n >> w;

    vector<pair<double, double>> mills(n); // pair: <processing_rate, travel_time>

    for (int i = 0; i < n; ++i) {
        cin >> mills[i].first >> mills[i].second;
    }

    sort(mills.begin(), mills.end(), [](const pair<double, double>& a, const pair<double, double>& b) {
        return a.second < b.second;
    });

    vector<double> times;

    for (int i = 0; i < n; ++i) {
        double travel_time_for_last_mill = 2.0 * mills[i].second;

        double wheat_at_nearer_mills = 0.0;
        for (int j = 0; j < i; ++j)
            wheat_at_nearer_mills += (travel_time_for_last_mill - 2.0 * mills[j].second) * mills[j].first;

        if (w > wheat_at_nearer_mills) {
            double remaining_wheat = w - wheat_at_nearer_mills;

            double total_processing = 0.0;
            for (int j = 0; j <= i; ++j) total_processing += mills[j].first;

            double parallel_time = remaining_wheat / total_processing;
            times.push_back(travel_time_for_last_mill + parallel_time);
        } 
	else times.push_back(travel_time_for_last_mill);
    }

    // Find and print the minimum time with 10 digits of precision
    double min_time = *min_element(times.begin(), times.end());
    cout << fixed << setprecision(10) << min_time << endl;

    return 0;
}
