
#include <iostream>
#include <iomanip>
#include <utility>
#include <random>

std::random_device rd;
std::mt19937 gen(rd());

const int maxn = 100000;
std::pair<int, int> a1[maxn+1], a2[maxn+1], a3[maxn+1];

int main(){
	std::ios_base::sync_with_stdio(false);
	std::cin.tie(nullptr);
    
    int n, t = 0, w;
    long long v = 0;
    std::cin >> n >> w;
    std::pair<int, int> *todo = a1;
    todo[0].first = n;
    for (int i = 1; i <= n; ++i) std::cin >> todo[i].second >> todo[i].first;
    
    while (todo[0].first){
        std::uniform_int_distribution<int> uid(1, todo[0].first);
        int i = uid(gen);
        int nt = 2*todo[i].first, nw = w;
        long long nv = v;
        
        std::pair<int, int> *before = a1, *after = a2;
        if (todo == a2) after = a3;
        else if (todo == a1) before = a3;
        before[0].first = after[0].first = 0;
        
        for (int i = 1; i <= todo[0].first; ++i){
            if (2*todo[i].first < nt) before[++before[0].first] = todo[i];
            else if (2*todo[i].first == nt) nv += todo[i].second;
            else after[++after[0].first] = todo[i];
        }
        
        bool too_much = v > 0 && nt-t > (w-1)/v;
        if (!too_much){
            nw -= v*(nt-t);
            for (int i = 1; i <= before[0].first; ++i){
                if (nt-2*before[i].first > (nw-1)/before[i].second){
                    too_much = true;
                    break;
                }
                nw -= before[i].second*(nt-2*before[i].first);
                nv += before[i].second;
            }
        }
        
        if (too_much) todo = before;
        else{
            t = nt;
            w = nw;
            v = nv;
            todo = after;
        }
    }
    
    std::cout << std::setprecision(13) << t+(long double)w/v << std::endl;
    return 0;
}
