
#include <iostream>
#include <iomanip>
#include <vector>
#include <utility>
#include <random>

std::random_device rd;
std::mt19937 gen(rd());

int main(){
    int n, t = 0, w;
    long long v = 0;
    std::cin >> n >> w;
    std::vector<std::pair<int, int>> todo(n);
    for (std::pair<int, int> &m : todo) std::cin >> m.second >> m.first;
    
    while (!todo.empty()){
        std::uniform_int_distribution<int> uid(0, todo.size()-1);
        int i = uid(gen);
        int nt = 2*todo[i].first, nw = w;
        long long nv = v;
        
        std::vector<std::pair<int, int>> before, after;
        for (const std::pair<int, int> &m : todo){
            if (2*m.first < nt) before.push_back(m);
            else if (2*m.first == nt) nv += m.second;
            else after.push_back(m);
        }
        
        bool too_much = v > 0 && nt-t > (w-1)/v;
        if (!too_much){
            nw -= v*(nt-t);
            for (const std::pair<int, int> &m : before){
                if (nt-2*m.first > (nw-1)/m.second){
                    too_much = true;
                    break;
                }
                nw -= m.second*(nt-2*m.first);
                nv += m.second;
            }
        }
        
        if (too_much) todo = before;
        else{
            t = nt;
            w = nw;
            v = nv;
            todo = after;
        }
    }
    
    std::cout << std::setprecision(13) << t+(long double)w/v << std::endl;
    return 0;
}
