#!/usr/bin/env python3

# Keep neighbours in an adjacency _set_ (instead of list),
# and remove the antiparallel edge of a traversed edge to prevent backtracking.

n, m = map(int, input().split())

N: list[set[int]] = [set() for _ in range(n)]
for _ in range(m):
    u, v = map(lambda x: int(x) - 1, input().split())
    N[u].add(v)
    N[v].add(u)

Q = [0]
pred: dict[int, int] = { 0: 0 }
for u in Q:
    for v in N[u]:
        N[v].remove(u) # don't want to travel back from v to u ever
        if v not in pred:
            pred[v] = u
            Q.append(v)
            continue
        pu, pv = [u], [v]
        for path in [pu,  pv]:
            while path[-1] != 0:
                path.append(pred[path[-1]])
        print(len(pu) + len(pv))
        print(*(w + 1 for w in pu[::-1] + pv))
        exit()
print("impossible")
