#!/usr/bin/env python3
from collections import deque


def main():
    # Read input
    n, e = (int(x) for x in input().split())
    home = 0

    adj = [[] for _ in range(n)]

    # Build adjacency graph
    for _ in range(e):
        i, j = (int(x) for x in input().split())
        i -= 1
        j -= 1

        adj[i].append(j)
        adj[j].append(i)

    # Compute answer
    ans = find_roadtrip(home, adj)

    if ans:
        print(len(ans))
        print(*(map(lambda x: x + 1, ans)))
    else:
        print("impossible")


def find_roadtrip(root, adj) -> [int]:
    """We perform a breadth first search starting from the root vertex. When we
    first come across a node which has already been visited from a different
    vertex in the graph, we know that this must give such a desired shortest
    loop."""
    q = deque([root])

    parents = [-1] * len(adj)
    parents[root] = -2

    def chase_to_root(n) -> [int]:
        """Find the shortest path from the given vertex to the root as given by
        the bfs."""
        path = []
        while True:
            path.append(n)
            n = parents[n]

            if n == -2:
                break

        return path

    while q:
        v = q.popleft()
        for w in adj[v]:
            if parents[w] == -1:
                parents[w] = v
                q.append(w)
            elif parents[v] != w:
                return list(reversed(chase_to_root(w))) + chase_to_root(v)

    return None


if __name__ == "__main__":
    main()
