#!/usr/bin/env python3

# For each length k>0 and oriented edge uv, count the digon-free s,uv-walks using k edges,
# i.e., the digon-free walks from s whose last edge is u->v.
# Worst case O(dm), where d is the output size, bounded by O(nm)

import sys

n, m = map(int, input().split())
Arc = tuple[int, int]
N: list[list[int]] = [[] for _ in range(n+1)] # ignore entry 0
for _ in range(m):
    u, v = map(int, input().split())
    N[u].append(v)
    N[v].append(u)

# pred[k][e] = an edge in a digon-free length-(k-1) walk connecting to e,
# or (1,1) if e is incident on 1

pred: list[dict[Arc, Arc]] = [{},  {(1, v): (1, 1) for v in N[1]}]

for k in range(2, 2*n-1):
    pred.append({})
    for u, v in pred[k-1]:
        for w in N[v]:
            if u == w: # u, v, w is a digon! skip it.
                continue
            pred[k][v, w] = (u, v)
            if w == 1:
                # found it, now print answer
                print(k + 1)
                while k:
                    print(w)
                    v, w = pred[k][v,w]
                    k -= 1
                print(1)
                sys.exit()
print("impossible")
