import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;

public class jeroenb {
	static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

	public static void main(String[] args) throws Exception {
		// Read input
		String[] ps = in.readLine().split(" ");
		int n = Integer.valueOf(ps[0]);
		int m = Integer.valueOf(ps[1]);
		ArrayList<Integer>[] adj = new ArrayList[n];
		for (int i = 0; i < n; i++)
			adj[i] = new ArrayList<Integer>();
		for (int i = 0; i < m; i++) {
			ps = in.readLine().split(" ");
			int u = Integer.valueOf(ps[0]);
			int v = Integer.valueOf(ps[1]);
			adj[u - 1].add(v - 1);
			adj[v - 1].add(u - 1);
		}

		// Run a BFS, when we reach an already visited node
		// from a different origin, we found a valid path.
		Queue<QState> q = new LinkedList<QState>();
		q.add(new QState(0, 0, 0));
		boolean[] seen = new boolean[n];
		int[] from = new int[n];
		int[] dist = new int[n];
		int best = -1;
		int best1 = -1;
		int best2 = -1;
		while (!q.isEmpty()) {
			QState top = q.poll();
			if (seen[top.i]) {
				int d = dist[top.i] + top.d;
				if (best == -1 || best > d) {
					best = d;
					best1 = top.i;
					best2 = top.from;
				}
				continue;
			}
			seen[top.i] = true;
			from[top.i] = top.from;
			dist[top.i] = top.d;

			for (int j : adj[top.i]) {
				if (j != top.from) {
					q.add(new QState(j, top.i, top.d + 1));
				}
			}
		}

		if (best == -1) {
			System.out.println("impossible");
			return;
		}
		
		// We found a path connected via best1 and best2
		ArrayList<Integer> path = new ArrayList<Integer>();

		// Visit first half in reversed order
		int j = best1;
		while (j != 0) {
			path.add(j);
			j = from[j];
		}
		path.add(0);
		Collections.reverse(path);

		// Now visit the other half of the path
		j = best2;
		while (j != 0) {
			path.add(j);
			j = from[j];
		}
		path.add(0);

		// And print it nicely
		System.out.println(path.size());
		for (int p : path) {
			System.out.print((p + 1) + " ");
		}
		System.out.println();
	}
}

class QState {
	public int i, from, d;

	public QState(int i, int from, int d) {
		this.i = i;
		this.from = from;
		this.d = d;
	}
}
