import java.io.*;
import java.util.*;

public class WendyFastScanner {
    static void getPath(List<Long> trip, List<List<Long>> adj, long[] parent, int v) {
        long cur = v;
        while (parent[(int) cur] != cur) {
            trip.add(cur);
            cur = parent[(int) cur];
        }
        trip.add(cur);
    }

    public static void main(String[] args) throws Exception {
        FastScanner sc = new FastScanner(System.in);
        int n = sc.nextInt();
        int m = sc.nextInt();
        List<List<Long>> adj = new ArrayList<>(n);
        for (int i = 0; i < n; ++i) adj.add(new ArrayList<>());
        for (int i = 0; i < m; ++i) {
            long u = sc.nextLong() - 1;
            long v = sc.nextLong() - 1;
            adj.get((int) u).add(v);
            adj.get((int) v).add(u);
        }
        long INF = 1_000_000_000L;
        long[] dist = new long[n];
        long[] parent = new long[n];
        Arrays.fill(dist, INF);
        Arrays.fill(parent, -1);
        dist[0] = 0;
        parent[0] = 0;
        long res = INF;
        int v1 = -1, v2 = -1;
        ArrayDeque<Integer> q = new ArrayDeque<>();
        q.add(0);
        while (!q.isEmpty()) {
            int cur = q.poll();
            for (long neighL : adj.get(cur)) {
                int neigh = (int) neighL;
                if (parent[neigh] == -1) {
                    q.add(neigh);
                    parent[neigh] = cur;
                    dist[neigh] = dist[cur] + 1;
                } else if (neigh == parent[cur]) {
                    // continue
                } else if (dist[neigh] + 1 + dist[cur] < res) {
                    res = dist[neigh] + 1 + dist[cur];
                    v1 = cur;
                    v2 = neigh;
                }
            }
        }
        if (v1 == -1) {
            System.out.println("impossible");
            return;
        }
        List<Long> trip = new ArrayList<>();
        getPath(trip, adj, parent, v1);
        Collections.reverse(trip);
        getPath(trip, adj, parent, v2);
        StringBuilder out = new StringBuilder();
        out.append(trip.size()).append('\n');
        for (long x : trip) out.append(x + 1).append('\n');
        System.out.print(out.toString());
    }

    static final class FastScanner {
        private final InputStream in;
        private final byte[] buffer = new byte[1 << 16];
        private int ptr = 0, len = 0;

        FastScanner(InputStream is) {
            in = is;
        }

        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buffer);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buffer[ptr++];
        }

        int nextInt() throws IOException {
            int c, s = 1, x = 0;
            do {
                c = read();
            } while (c <= 32);
            if (c == '-') {
                s = -1;
                c = read();
            }
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return x * s;
        }

        long nextLong() throws IOException {
            int c, s = 1;
            long x = 0;
            do {
                c = read();
            } while (c <= 32);
            if (c == '-') {
                s = -1;
                c = read();
            }
            while (c > 32) {
                x = x * 10 + (c - '0');
                c = read();
            }
            return s == 1 ? x : -x;
        }

        String next() throws IOException {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = read();
            } while (c <= 32);
            while (c > 32) {
                sb.append((char) c);
                c = read();
            }
            return sb.toString();
        }
    }
}
