#!/usr/bin/env python3

import sys

with open(sys.argv[1]) as infile, open(sys.argv[2]) as ansfile:
    lines = [line.strip() for line in infile.readlines()]
    n, m = map(int, lines.pop(0).split())
    if n > 1000:  # don't try to layout huge graphs
        print(r"""\documentclass[varwidth]{standalone}
    \begin{document} (too large) \end{document}
    """)
        sys.exit()
    edges = []
    for i, line in enumerate(lines):
        edges.append(tuple(map(int, line.split())))

    anslines = ansfile.readlines()
    answer = [] if anslines[0][0] == "i" else anslines[1].split()

    print(r"""\documentclass[varwidth]{standalone}
% Make the PDF content reproducible by omitting time-/machine-based metadata: https://tex.stackexchange.com/a/313605
\pdfvariable suppressoptionalinfo \numexpr32+64+512\relax
\usepackage{tikz}
  \usetikzlibrary{graphs}
  \usetikzlibrary{graphdrawing}
  \usegdlibrary{force}
\begin{document}
    """)
    print(r"\begin{tikzpicture}[inner sep=1pt, font=\sffamily]")
    print(r"\graph[spring layout")
    if n > 9:
        print(", empty nodes, nodes={fill}")
    print(r"] {")
    for u, v in edges:
        print(rf"{u}--{v},")
    print(r"};")
    print(r"\draw [red, very thick, ->]")
    print("--".join([f"({v})" for v in answer]))
    print(r";")
    print(r"\end{tikzpicture}")
    print(r"\end{document}")
