#include "validation.h"

// Check the grammar of the input files.
// You should also check properties of the input.
// E.g., check that a graph is connected.

int main(int argc, char *argv[]) {
    InputValidator v(argc, argv);
    int n = v.read_integer("n", 2, 100000);
    v.space();
    int m = v.read_integer("m", 1, 200000);
    v.newline();

    std::set<std::pair<int, int>> edges;
    for (int i=0; i < m; ++i) {
	auto edge = v.read_integers("edge", 2, 1, n, StrictlyIncreasing);
	std::pair<int, int> e = {edge[0], edge[1]};
    
	if (!edges.insert(e).second) v.WA("Duplicate edge");
    }
    return 0;
}
