import random
from argparse import ArgumentParser

parser = ArgumentParser(description="Create a random tree and a cycle, possibly connected")

parser.add_argument("-n", type=int)
parser.add_argument("--seed", type=int, default=0)

args = parser.parse_args()
random.seed(args.seed)
n = args.n

# cycle using all nodes 1..n
edges = list(zip(range(1, n), range(2, n + 1))) + [(1, n)]

print(n, len(edges))
for u, v in edges:
    print(u, v)
