import sys

lines = sys.stdin.readlines()

sol = [
        "0-1",
        "1-0",
        "2-4",
        "3-0",
        "4-0",
        "5-5",
        "6-4",
        "7-2",
        "8-2",
        "9-4",
        "10-4",
        "11-1",
        "12-5",
        "13-4",
        "14-2",
        "15-1",
        ]

print(r"\documentclass{standalone} \usepackage{tikz} \begin{document} \begin{tikzpicture} [xscale=1.5, yscale=.6]")


for r in range(6):
    for c in range(16):
        name = f"{c}-{r}"
        if name in sol:
            print(r"\node",  f"({name}) at ({c}, {-r})", r"[circle, fill=red!50, inner sep=1pt, minimum size=4mm, draw, thick] {\sf ",  lines[r][c], "};")
        else:
            print(r"\node",  f"({name}) at ({c}, {-r})", r"[circle, inner sep=1pt, minimum size=4mm, draw, thick] {\sf ",  lines[r][c], "};")

print(r"""
\node (s) at (-1,-2.5) [circle, fill, inner sep=2pt, minimum size=0mm] {};
\node (t) at (16,-2.5) [circle, fill, inner sep=2pt, minimum size=0mm] {};
\foreach \row in {0,...,5} { \draw [->, densely dotted] (s)--(0-\row); }
\foreach \row in {0,...,5} { \draw [->, densely dotted] (15-\row)--(t); }
\draw [-, ultra thick, red!50] (s)--(0-1);
\draw [-, ultra thick, red!50] (15-1)--(t);
      """)

def thickness(rrow):
    match rrow:
        case 0:
            return "[densely dotted]"
        case 5:
            return "[thick]"
        case _:
            return ""

for r in range(6):
    for rr in range(6):
        for c in range(15):
            if lines[rr][c+1] >= lines[r][c] != 'Q' or lines[r][c] == 'Q' and lines[rr][c] >= 'U':
                from_name = f"{c}-{r}"
                to_name = f"{c+1}-{rr}"
                if from_name in sol and to_name in sol:
                    print(r"\draw [red!50, ultra thick]",
                          f"({c}-{r})--({c+1}-{rr});")
                print(r"\draw [->]",
                      thickness(rr),
                      f"({c}-{r})--({c+1}-{rr});")

print("""\end{tikzpicture} \end{document}""")
