#!/usr/bin/env python3
import random
import sys

from string import ascii_uppercase

letters = ascii_uppercase.replace("Q", "")  # "Q" can only appear once, so re-add it later

# Init seed with first argument
random.seed(int(sys.argv[1]))

remaining_args, max_duplicates, sorted_dice = sys.argv[2:], False, False
while remaining_args:
    match remaining_args.pop():
        case "--max-duplicates":
            max_duplicates = True
        case "--sorted-dice":
            sorted_dice = True

dice = [random.sample(letters, 2) * 3 if max_duplicates else random.choices(letters, k=6) for _ in range(16)]
dice[random.randrange(16)][random.randrange(6)] = "Q"  # Add random single "Q" anywhere
for i in range(16):
    random.shuffle(dice[i])
if sorted_dice:
    dice.sort(key=lambda d: sorted(d))

for f in range(6):
    print("".join(dice[i][f] for i in range(16)))
