#include "validation.h"

// For DYNAMIC OUTPUT PROBLEMS:
// This program will be called as
// output_validator input answer < team_output
//
// Please check the grammar of the team output using the Validator class.
// See input_validator.cpp for information on how to use the Validator class.
// You should also check the validity of the answer here.
// For example, check that a tree printed by the team is a tree indeed.

// For INTERACTIVE PROBLEMS:
// Write your output validator as usual, but make sure to flush all standard
// output. Call `v.set_WA_handler(lambda)` to gracefully handle failures when
// parsing team output. You could e.g. send a '-1' to the submission to tell it
// to stop running.

int main(int argc, char *argv[]) {
    std::ifstream in(argv[1]);
    OutputValidator v(argc, argv);

    int y;
    in >> y;

    int n = v.read_integer("N", 1, 10000);
    v.newline();
    auto xs = v.read_integers("croots",n,-10000,10000);

    // check sum of cubes vals = input number
    long long sum = 0;
    for(auto x:xs) sum+=((long long)x)*x*x;
    v.check(sum==y,"Sum of cubes must equal input");


}
