#pragma GCC optimize("Ofast")
#include <iostream>
#include <vector>
#include <array>
#include <random>
#include <chrono>
using namespace std;
mt19937 rng(69);
int rnd(int l, int r) {return uniform_int_distribution(l,r)(rng);}
const int A = 1e6;

int main() {
    auto t0 = chrono::high_resolution_clock::now();
    int n; cin >> n;
    vector<int> f(n);
    for(auto& i : f) cin >> i;
    
    vector<int> t(n);
    for(auto& i : t) cin >> i;
    f.insert(f.begin(),0);
    t.insert(t.begin(),0);
    auto getScore = [&](array<int,4> off) {
        long long cur=0;
        for(int i=1;i<=n;++i) {
            long long nw = 1e18;
            for(int j=0;j<4;++j) {
                if(f[i-1]<f[i]) {
                    int o = (off[j] - (cur-f[i-1]))%(2*A);
                    if(o<0) o+=2*A;
                    nw=min(nw,cur+o + f[i]-f[i-1]);

                } else {
                    int o = (off[j] - (cur+f[i]))%(2*A);
                    if(o<0) o+=2*A;
                    nw=min(nw,cur+o + f[i-1]-f[i]);
                }
            }
            cur=nw+t[i];

        }
        return cur;
    };
    long long ans = 1e18;

    while((chrono::high_resolution_clock::now() - t0).count()<1.9e9) {
        cerr << "ITER!\n";
        array<int,4> off = {0,rnd(0,A*2-1),rnd(0,A*2-1),rnd(0,A*2-1)};
        auto s = getScore(off);
        auto P = [&](long long E,long long E_next,double T){ // simulated annealing.
            double prob =  exp(-(E_next-E)/T);
            if(prob > 1) return true;
            else{
                bernoulli_distribution d(prob); 
                return d(rng);
            }
        };
        for(double T = 1;T>=1e-8;T*=0.999) {
            // transition!
            int who = rnd(1,3);
            int x = rnd(-int(ceil(A*T)),int(ceil(A*T)));
            auto noff = off;
            noff[who]+=x;
            noff[who]%=2*A;
            if(noff[who]<0) noff[who]+=2*A;
            auto ns = getScore(noff);
            if(P(s,ns,T*1e4)) {
                off=noff;
                s=ns;
            }
            ans=min(ans,s);

        }
        ans=min(ans,s);
    }
    cout << ans << '\n';
}